# Voice-First Workflows

Multiple sources converge on voice as a transformative input for Claude Code. Allie K. Miller claims 95% of her prompts require zero typing.

## Why It Matters

"The game-changer is pairing dictation with AI editing — dictating first to capture your ideas at speaking speed, then using AI to clean it up." — Hannah Stulberg

You think faster than you type. Dictation captures the full stream of consciousness. Claude handles the formatting.

## Tools

- **Wispr Flow** — popular dictation tool
- **Superwhisper** — another option
- **Parakeet** (via Super Voice Assistant) — newer entrant
- Built-in macOS dictation works too for quick stuff

## The Pineapple Technique

This one blew my mind. Allie K. Miller uses a unique code word — "pineapple" — to embed AI instructions within her dictation. "It's like a way to speak to the AI on the side of the main task."

So you're dictating a PRD and you say "pineapple make this section more concise pineapple" and the AI knows that's a meta-instruction, not content.

## PM Angle

Dictation + Claude is the fastest path from "rough idea" to "polished artifact." Think about the workflow:
1. Speak your thinking (2 minutes)
2. Claude formats it into a PRD (seconds)
3. Review and refine

Compare to: staring at a blank doc trying to write the perfect spec.

This connects to [[Plan Mode]] — you could dictate your plan, have Claude structure it, then review. And to [[The Junior Employee Mental Model]] — you're verbally briefing your employee, not writing a formal memo.

## Connection to Obsidian

Vin's whole system is about writing as infrastructure. Voice lowers the friction of writing. More writing → richer vault → smarter [[Custom Commands]] and thinking tools.

The loop: speak → capture → link → let agents surface patterns.

## Related

- [[Plan Mode]] — voice as a planning input
- [[The Junior Employee Mental Model]] — verbal delegation
- [[Custom Commands]] — build a command that takes voice input and routes it
